.ifndef __SPRITE_HANDLER__
.define __SPRITE_HANDLER__

.bank 0 slot 0

;converts a object into sprites, taking in acount the most significant part
; of the objects Ys.
;iy:object Address
;h : most significant part of the attribute Table of the object
;de : postion on the sprite Table
;returns:
;de will be positioned on the next free position in the sprite table
;destroys:
;everything else, but the index registers
.section "verticalObjectToSprites" free
verticalObjectToSprites:
	ld l, (iy + object.objType)
	dec l
	ret m
	
	sla l
	ld c, (hl)
	inc l
	ld h, (hl)
	ld l, c
	ld b, (hl)
	inc hl
	ld a, (iy + object.y)
		
-:		push af
		add a, (hl)
		inc hl
		ld c, a
		sbc a, a
		cp (iy + object.y + 1)
		jr nz, +
			ld a, 231
			cp c
			jr c, +
				ld a, (resolutionDependencies.objectToSpriteYOffset)
				add a, c
				ld (de), a
				rlc e
				ld a, (hl)
				add a, (iy + object.x)
				ld (de), a
				inc hl
				inc e
				ld c, d; make sure b will not be decremented
				ldi
				rrc e
			jr ++
+:				inc hl
				inc hl
++:			pop af
	djnz -
	ret
.ends


;convert the 18 first objects in the sprite table into sprites, cleaning
;all the rest of the sprite table
;returns:
;de: next free position on the sprite table
;iy: 19th object
;b : 0
.section "verticalObjectsToSprites" free
verticalObjectsToSprites:	
	call clearSpriteTable
	ld de, spriteTable
	ld iy, objectTable.1.objType
	ld b, $12	
-:		push bc
		ld h, >objects.openingTable
		call verticalObjectToSprites

		ld bc, _sizeof_object
		add iy, bc
		pop bc	
	djnz -
	ret		
.ends


;Clear object table
.section "clearObjectTable" free
clearObjectTable:
	xor a
	ld hl, objectTable.1.objType
	ld (hl), a
	ld de, objectTable.1.objType + 1
	fastLdir (18 * _sizeof_object) - 1
;fallThrow
;set $f1 to all ys sprites.
clearSpriteTable:;Lbl_8473:
	ld a, $f0
	ld b, 64
	ld hl, spriteTable
	
-:		ld (hl), a
		inc l
	djnz -	
	ret
.ends

.endif